@extends('admin.layout.master')
@section('import-css')
    <link href="{{ asset('assets/admin/css/bootstrap-fileinput.css') }}" rel="stylesheet">
@stop
@section('body')
    <div class="card">
        <div class="card-header bg-white font-weight-bold">
            <h4>{{$page_title}}</h4>
        </div>

        {!! Form::model($basic,['route'=>['manage-footer-update'],'method'=>'PUT','role'=>'form','class'=>'form-horizontal','files'=>true]) !!}

        <div class="card-body">

            <div class="row">
                <div class="col-md-12">

                    <div class="form-group{{ $errors->has('exchange_confirm_text') ? ' has-error' : '' }}">
                        <label class="col-md-12"><strong class="text-uppercase">Exchange Preview Confirm Text </strong></label>
                        <div class="col-md-12">
                            <textarea name="exchange_confirm_text" class="form-control" rows="3" required>{{$basic->exchange_confirm_text}}</textarea>
                            @if ($errors->has('exchange_confirm_text'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('exchange_confirm_text') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>
                    <div class="form-group{{ $errors->has('exchange_confirm_text2') ? ' has-error' : '' }}">
                        <label class="col-md-12"><strong class="text-uppercase">Exchange  Confirm Text 2 </strong></label>
                        <div class="col-md-12">
                            <textarea name="exchange_confirm_text2" class="form-control" rows="3" required>{{$basic->exchange_confirm_text2}}</textarea>
                            @if ($errors->has('exchange_confirm_text2'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('exchange_confirm_text2') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>
                    <div class="form-group{{ $errors->has('exchange_confirm_text3') ? ' has-error' : '' }}">
                        <label class="col-md-12"><strong class="text-uppercase">Exchange Confirm Text 3</strong></label>
                        <div class="col-md-12">
                            <textarea name="exchange_confirm_text3" class="form-control" rows="3" required>{{$basic->exchange_confirm_text3}}</textarea>
                            @if ($errors->has('exchange_confirm_text3'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('exchange_confirm_text3') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>
                    <div class="form-group{{ $errors->has('exchange_confirm_text4') ? ' has-error' : '' }}">
                        <label class="col-md-12"><strong class="text-uppercase">Exchange Confirm Text 4 </strong></label>
                        <div class="col-md-12">
                            <textarea name="exchange_confirm_text4" class="form-control" rows="3" required>{{$basic->exchange_confirm_text4}}</textarea>
                            @if ($errors->has('exchange_confirm_text4'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('exchange_confirm_text4') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>



                    <div class="form-group{{ $errors->has('short_about') ? ' has-error' : '' }}">
                        <label class="col-md-12"><strong class="text-uppercase">WebSite short About </strong></label>
                        <div class="col-md-12">
                            <textarea name="short_about" rows="3" class="form-control"
                                      required>{{ $basic->short_about }}</textarea>
                            @if ($errors->has('short_about'))
                                <span class="help-block">
                                                <strong>{{ $errors->first('short_about') }}</strong>
                                            </span>
                            @endif
                        </div>
                    </div>





                    <div class="form-group{{ $errors->has('tawkto') ? ' has-error' : '' }}">
                        <label class="col-md-12"><strong class="text-uppercase">Chat Script</strong></label>
                        <div class="col-md-12">
                            <textarea name="tawkto" rows="10" class="form-control" required>{{ $basic->tawkto }}</textarea>
                            @if ($errors->has('tawkto'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('tawkto') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>


                    <div class="form-group{{ $errors->has('fb_comment') ? ' has-error' : '' }}">
                        <label class="col-md-12"><strong class="text-uppercase">Facebook Comment Script</strong></label>
                        <div class="col-md-12">
                            <textarea name="fb_comment" rows="10" class="form-control" required>{{ $basic->fb_comment }}</textarea>
                            @if ($errors->has('fb_comment'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('fb_comment') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>



                </div>
            </div><!-- row -->

        </div>
        <div class="card-footer bg-white">
            <button class="btn btn-primary btn-block btn-lg" type="submit"> <i class="fa fa-send"></i> Update</button>
        </div>


        {!! Form::close() !!}
    </div>


@stop

@section('import-script')
    <script src="{{ asset('assets/admin/js/bootstrap-fileinput.js') }}"></script>
@stop